/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common.registration;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistryEntry;
import slimeknights.mantle.registration.object.ItemObject;

public class CastItemObject
extends ItemObject<Item> {
    private final ResourceLocation name;
    private final Supplier<? extends Item> sand;
    private final Supplier<? extends Item> redSand;
    private final TagKey<Item> singleUseTag;
    private final TagKey<Item> multiUseTag;

    public CastItemObject(ResourceLocation name, Item gold, Item sand, Item redSand) {
        super((ForgeRegistryEntry)gold);
        this.name = name;
        this.sand = sand.delegate;
        this.redSand = redSand.delegate;
        this.singleUseTag = this.makeTag("single_use");
        this.multiUseTag = this.makeTag("multi_use");
    }

    public CastItemObject(ResourceLocation name, ItemObject<? extends Item> gold, Supplier<? extends Item> sand, Supplier<? extends Item> redSand) {
        super(gold);
        this.name = name;
        this.sand = sand;
        this.redSand = redSand;
        this.singleUseTag = this.makeTag("single_use");
        this.multiUseTag = this.makeTag("multi_use");
    }

    protected TagKey<Item> makeTag(String type) {
        return TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation(this.name.m_135827_(), "casts/" + type + "/" + this.name.m_135815_()));
    }

    public Item getSand() {
        return Objects.requireNonNull(this.sand.get(), "CastItemObject missing sand");
    }

    public Item getRedSand() {
        return Objects.requireNonNull(this.redSand.get(), "CastItemObject missing red sand");
    }

    public List<Item> values() {
        return Arrays.asList((Item)this.get(), this.getSand(), this.getRedSand());
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public TagKey<Item> getSingleUseTag() {
        return this.singleUseTag;
    }

    public TagKey<Item> getMultiUseTag() {
        return this.multiUseTag;
    }
}

